close all; clear; clc;

appCurr =[4.2,4,3,2,1];
appCurrUnc=[.2121,0.212,0.2115,0.211,0.2105];
measCurr=[4.129366293,3.926501865,2.965124716,2.002953243,1.07947505];
measCurrUnc=[0.012034573,0.012012091,0.011906093,0.011801145,0.01122791];


currFig=errorbar( appCurr, measCurr, measCurrUnc, measCurrUnc, appCurrUnc, appCurrUnc, "." ); 
hold on
grid on; grid minor; 
xlabel("Applied Current (A)" ); ylabel("Measured Current (A)"); 
xlim([0,5]); ylim([0,5]); 
title("Measured Current vs Applied Current")
hold off
saveas(currFig, "ConstantCurrentLoadCurve.png");

appRes = [2,5,10,15,20];
appResUnc = [0.2,0.2,0.2,0.2,0.2];
measRes=[2.644281087,5.541416205,10.33681,14.77706293,19.70888911];
measResUnc = [0.005795268,0.022374813,0.070394169,0.129699029,0.164497145];

resFig=errorbar( appRes, measRes, measResUnc, measResUnc, appResUnc, appResUnc, "." ); 
hold on
grid on; grid minor; 
xlabel("Applied Resistance (Ω)" ); ylabel("Measured Resistance (Ω)"); 
xlim([0,25]); ylim([0,25]); 
title("Measured Resistance vs Applied Resistance")
hold off
saveas(resFig, "ConstantResistanceLoadCurve.png");