function fig = plotKvCurve( fig, V, u_V, omega, u_omega, Kv, u_Kv, genName )
    domain = linspace( 0, V( end ), 100 );
    range = linspace( 0, omega( end ), 100 );
    domainLen = length( domain );
    rangeLen = length( range );

    eqStr = sprintf( "ω = (%.0f ± %.1e) * V", Kv, u_Kv );
    
    figure( fig )
    hold on
    grid on
    grid minor
    errorbar( V, omega, u_omega, u_omega, u_V, u_V, "." );
    plot( domain, Kv * domain, "r" )
    plot( domain, ( Kv - u_Kv ) * domain, ":r" )
    plot( domain, ( Kv + u_Kv ) * domain, ":r" )
    text( domain( ceil( domainLen / 3 ) ), range( floor( 2 * rangeLen / 3 ) ), eqStr )
    xlabel( "Voltage, V (V)" )
    ylabel( "Rotaional Speed, ω (RPM)" )
    titleStr = genName + ": Kv Curve";
    title( titleStr );
    legend( "Data", "Kv", "Kv Error", "Location", "best" )
    hold off
end