function [ x_bar, u_x_bar ] = getWeightedAverageData( x, u_x )
    xLen = length( x );
    weightedAvgXLen = xLen / Constants.SAMPLE_AMT;

    x_bar = zeros( weightedAvgXLen, 1 );
    u_x_bar = zeros( weightedAvgXLen, 1 );

    for weightedAvgIdx = 1 : weightedAvgXLen
        sampledIndices = Constants.SAMPLE_AMT * ( weightedAvgIdx - 1 ) + 1 : Constants.SAMPLE_AMT * weightedAvgIdx;

        sampled_x = x( sampledIndices );
        sampled_u_x = u_x( sampledIndices );

        [ x_bar( weightedAvgIdx ), u_x_bar( weightedAvgIdx) ] = getWeightedAverage( sampled_x, sampled_u_x );

    end
end