function [ P_e, u_P_e ] = getElectricalPower( V, u_V, I, u_I )
    syms V_sym I_sym

    eqSym = V_sym * I_sym;

    eqSymScalarParams = []; 
    eqSymArrParams = [ V_sym, I_sym ]; 
    eqSymScalarArgs = []; 
    eqSymArrArgs = [ V, I ]; 

    u_P_e_V = getErrorPropagatedUncertainty( eqSym, ...
                                             V_sym, ...
                                             u_V, ...
                                             eqSymScalarParams, ...
                                             eqSymArrParams, ...
                                             eqSymScalarArgs, ...
                                             eqSymArrArgs );

    u_P_e_I = getErrorPropagatedUncertainty( eqSym, ...
                                             I_sym, ...
                                             u_I, ...
                                             eqSymScalarParams, ...
                                             eqSymArrParams, ...
                                             eqSymScalarArgs, ...
                                             eqSymArrArgs );

    P_e = solveEquation( eqSym, ...
                         eqSymScalarParams, ...
                         eqSymArrParams, ...
                         eqSymScalarArgs, ...
                         eqSymArrArgs );
    u_P_e = getTotalUncertainty( u_P_e_V, u_P_e_I );
end