function [ V_cal, u_V_cal ] = getCalibratedVoltage( V_uncal, u_V_uncal )
    syms slopeSym V_uncal_sym interceptSym

    eqSym = slopeSym .* V_uncal_sym + interceptSym;

    eqSymScalarParams = [ slopeSym, interceptSym ]; 
    eqSymArrParams = V_uncal_sym; 

    [ ~, slope, intercept, confidenceInterval ] = getVoltageCalibrationResults();
%     [ measuredV, actualV ] = getCalibrationData( Constants.VOLTAGE_CALIBRATION_FILE_PATH );
%     [ slope, intercept, ci ] = getCalibrationCurve( measuredV, actualV );
    
    eqSymScalarArgs = [ slope, intercept ]; 
    eqSymArrArgs = V_uncal;

    u_V_cal_V_uncal = getErrorPropagatedUncertainty( eqSym, ...
                                                 V_uncal_sym, ...
                                                 u_V_uncal, ...
                                                 eqSymScalarParams, ...
                                                 eqSymArrParams, ...
                                                 eqSymScalarArgs, ...
                                                 eqSymArrArgs );

    V_cal = solveEquation( eqSym, ...
                           eqSymScalarParams, ...
                           eqSymArrParams, ...
                           eqSymScalarArgs, ...
                           eqSymArrArgs);
    u_V_cal = getTotalUncertainty( u_V_cal_V_uncal, confidenceInterval );

end