function [ T, u_T ] = getCalibratedTorque( adcCount )
    syms slopeSym interceptSym adcCountSym

    eq = slopeSym * adcCountSym + interceptSym;

    eqScalarParams = [ slopeSym, interceptSym ]; 
    eqArrParams = adcCountSym; 

    [ ~, slope, intercept, confidenceInterval ] = getTorqueCalibrationResults();
%     [ adcCountCalData, massCalData ] = getCalibrationData( Constants.TORQUE_CALIBRATION_FILE_PATH );
%     torqueByMomentArm = getTorqueByMomentArm( massCalData );
% 
%     [ slope, intercept, confidenceInterval ] = getCalibrationCurve( adcCountCalData, ...
%                                                                     torqueByMomentArm );
    
    eqScalarArgs = [ slope, intercept ]; 
    eqArrArgs = adcCount;

    T = solveEquation( eq, ...
                       eqScalarParams, ...
                       eqArrParams, ...
                       eqScalarArgs, ...
                       eqArrArgs );
    u_T = confidenceInterval * ones( length( T ), 1 );
end