function [ I, u_I ] = getCalibratedCurrent( I_uncal, u_I_uncal )
    syms slopeSym interceptSym I_uncal_sym

    eq = slopeSym * I_uncal_sym + interceptSym;

    eqScalarParams = [ slopeSym, interceptSym ];
    eqArrParams = I_uncal_sym; 

    [ ~, slope, intercept, confidenceInterval ] = getCurrentCalibrationResults();
%     [ measuredI, actualI ] = getCalibrationData( Constants.CURRENT_CALIBRATION_FILE_PATH );
%     [ slope, intercept, ci ] = getCalibrationCurve( measuredI, actualI );

    eqScalarArgs = [ slope, intercept ]; 
    eqArrArgs = I_uncal; 

    u_I_I_uncal = getErrorPropagatedUncertainty( eq, ...
                                               I_uncal_sym, ...
                                               u_I_uncal, ...
                                               eqScalarParams, ...
                                               eqArrParams, ...
                                               eqScalarArgs, ...
                                               eqArrArgs );

    I = solveEquation( eq, ...
                       eqScalarParams, ...
                       eqArrParams, ...
                       eqScalarArgs, ...
                       eqArrArgs );
    u_I = getTotalUncertainty( confidenceInterval, u_I_I_uncal );
end