function [ avgData, stdErr_avgData ] = getAveragedData( rawData )
    rawDataLen = length( rawData );
    avgDataLen = rawDataLen / Constants.SAMPLE_AMT;

    avgData = zeros( avgDataLen, 1 );

    stdDev_avgData = zeros( avgDataLen, 1 );

    for avgIdx = 1 : avgDataLen
        rawIndices = Constants.SAMPLE_AMT * ( avgIdx - 1 ) + 1 : Constants.SAMPLE_AMT * avgIdx;

        sampledRawData = rawData( rawIndices );

        avgData( avgIdx ) = mean( sampledRawData );

        stdDev_avgData( avgIdx ) = std( sampledRawData );
    end

    stdErr_avgData = stdDev_avgData / sqrt( Constants.SAMPLE_AMT );
end