// Preprocessor directives
#ifndef TORQUE_TRANSDUCER_AMP_SENSOR_H
#define TORQUE_TRANSDUCER_AMP_SENSOR_H

// Header files
#include "HX711.h"
#include "Sensor.h"

#define LOAD_CELL_AMP_SAMPLE_AMT 1
#define TORQUE_TRANSDUCER_CALIBRATION_CURVE_SLOPE 0.00249
#define TORQUE_TRANSDUCER_CALIBRATION_CURVE_INTERCEPT 52.6

class TorqueTransducerAmpSensor : public Sensor {
  public:
    TorqueTransducerAmpSensor( const int dataPin, 
                               const int clockPin, 
                               const char *torqueUnit, 
                               const unsigned int num_of_samples = 1,
                               const float calibrationCurveSlope = 1,
                               const float calibrationCurveIntercept = 0 );

    void initialize() override;

    void measure() override;

  private:
    HX711 scale;
    int dPin;
    int clkPin;
};

#endif // TORQUE_TRANSDUCER_AMP_SENSOR_H
