#include "TorqueTransducerAmpSensor.h"

TorqueTransducerAmpSensor::TorqueTransducerAmpSensor( const int dataPin, 
                                                      const int clockPin, 
                                                      const char *torqueUnit, 
                                                      const unsigned int num_of_samples = 1,
                                                      const float calibrationCurveSlope = 1,
                                                      const float calibrationCurveIntercept = 0 )
{
  dPin = dataPin;
  clkPin = clockPin;
  measurement = 0;
  snprintf( unit, sizeof( unit ), "%s", torqueUnit );
  sampleAmt = num_of_samples;
  calCurveSlope = calibrationCurveSlope;
  calCurveIntercept = calibrationCurveIntercept;
}

void TorqueTransducerAmpSensor::initialize()
{
  scale.begin( dPin, clkPin );
}

void TorqueTransducerAmpSensor::measure()
{
    digitalMeasurement = scale.read_average( sampleAmt );
    measurement = calCurveSlope * digitalMeasurement + calCurveIntercept;
}
