// Preprocessor directives
#ifndef MICRO_SD_CARD_READER_H
#define MICRO_SD_CARD_READER_H

// Header files
#include <SD.h>
#include "StandardConstants.h"
#include "ArduinoUtilities.h"
#include "Sensor.h"
#include "ControlConstants.h"

// Constants
#define DELIMETER TAB
#define TIME_UNIT "s"
#define VOLTAGE_UNIT "V"
#define CURRENT_UNIT "A"
#define ROTATIONAL_SPEED_UNIT "RPM"
#define TORQUE_UNIT "N-mm"
#define MAX_FILE_PREFIX_NAME_LEN 4 // NOTE: This includes the null char ('\0'), 
                                   //       so user really has 3 characters to enter

enum CARD_READER_CODES {
  START_WRITING = 1,
  CONTINUE_WRITING,
  STOP_WRITING,
  CONTINUOUS_DAQ = -1
};

// SD Card Reader
class MicroSdCardReader
{
  public:
    MicroSdCardReader( const int chipSelectPin );

    bool initialize();

    void createFileName( const char *inputFileName );

    void writeHeader();

    void writeTime();

    void writeData( const Sensor *sensor );

    void writeNewLine();

    File getFile();

    const char *getFileName();

    void setCardIsAvailable( const bool isAvailable );

    bool getCardIsAvailable();

    void setWritingInCard( const bool isWriting );

    bool getWritingInCard();

    void openFile();

    void closeFile();

    void setNumOfWrites( int val );

    int getNumOfWrites();

    void resetNumOfWrites();

  private:
    int csPin;
    char fileName[ 8 ];
    File dataFile;
    bool cardIsAvailable;
    bool writingInCard;
    int numOfWrites;
    int origNumOfWrites;
};

#endif // MICRO_SD_CARD_READER_H