// Header files
#include "MicroSdCardReader.h"

MicroSdCardReader::MicroSdCardReader( const int chipSelectPin )
{
      csPin = chipSelectPin;
      cardIsAvailable = false;
      writingInCard = false;
      origNumOfWrites = CONTINUOUS_DAQ;
      numOfWrites = CONTINUOUS_DAQ;
}

bool MicroSdCardReader::initialize()
{
  if ( SD.begin( csPin ) )
  {
    setCardIsAvailable( true );
  }
  else
  {
    setCardIsAvailable( false );
  }
  return cardIsAvailable;
}

void MicroSdCardReader::createFileName( const char *inputFileName )
{
  unsigned int counter = 0;

  if ( cardIsAvailable )
  {
    snprintf( fileName, "%s", inputFileName );

    while ( SD.exists( fileName ) )
    {
      sprintf( fileName, "%s%d", inputFileName, counter );

      counter++;
    }
  }
}


void MicroSdCardReader::writeHeader()
{
  if ( cardIsAvailable && writingInCard && dataFile )
  {

    // Serial.print( F( "Time (" ) );
    // Serial.print( TIME_UNIT );
    // Serial.print( F( ")" ) );
    // Serial.print( DELIMETER );

    // Serial.print( F( "Digital Voltage Value" ) );
    // Serial.print( DELIMETER );

    // Serial.print( F( "Calibrated Voltage (" ) );
    // Serial.print( VOLTAGE_UNIT );
    // Serial.print( F( ")" ) );
    // Serial.print( DELIMETER );

    // Serial.print( F( "Digital Current Voltage Value" ) );
    // Serial.print( DELIMETER );

    // Serial.print( F( "Calibrated Current (" ) );
    // Serial.print( CURRENT_UNIT );
    // Serial.print( F( ")" ) );
    // Serial.print( DELIMETER );

    // Serial.print( F( "Ticks Per Revolution (Ticks/Rev)" ) );
    // Serial.print( DELIMETER );

    // Serial.print( F( "RotationalSpeed (" ) );
    // Serial.print( ROTATIONAL_SPEED_UNIT );
    // Serial.print( F( ")" ) );
    // Serial.print( DELIMETER );

    // Serial.print( F( "Digital Torque Value" ) );
    // Serial.print( DELIMETER );

    // Serial.print( F( "Torque (" ) );
    // Serial.print( TORQUE_UNIT );
    // Serial.println( F( ")" ) );


    dataFile.print( F( "Time (" ) );
    dataFile.print( TIME_UNIT );
    dataFile.print( F( ")" ) );
    dataFile.print( DELIMETER );

    dataFile.print( F( "Voltage ADC Value" ) );
    dataFile.print( DELIMETER );

    dataFile.print( F( "Voltage (" ) );
    dataFile.print( VOLTAGE_UNIT );
    dataFile.print( F( ")" ) );
    dataFile.print( DELIMETER );

    dataFile.print( F( "Current ADC Value" ) );
    dataFile.print( DELIMETER );

    dataFile.print( F( "Current (" ) );
    dataFile.print( CURRENT_UNIT );
    dataFile.print( F( ")" ) );
    dataFile.print( DELIMETER );

    dataFile.print( F( "Ticks Per Revolution (Ticks/Rev)" ) );
    dataFile.print( DELIMETER );

    dataFile.print( F( "RotationalSpeed (" ) );
    dataFile.print( ROTATIONAL_SPEED_UNIT );
    dataFile.print( F( ")" ) );
    dataFile.print( DELIMETER );

    dataFile.print( F( "Torque ADC Value" ) );
    dataFile.print( DELIMETER );

    dataFile.print( F( "Torque (" ) );
    dataFile.print( TORQUE_UNIT );
    dataFile.println( F( ")" ) );
  }
  // else {
  //   setCardIsAvailable( false );
  // }
}

void MicroSdCardReader::writeTime() {
  float seconds = getSeconds();

  if ( cardIsAvailable && 
       writingInCard && 
       dataFile && 
       ( numOfWrites > 0 || 
       numOfWrites == CONTINUOUS_DAQ ) )
  {

    // Serial.print( seconds );
    // Serial.print( DELIMETER );

    dataFile.print( seconds );
    dataFile.print( DELIMETER );
  }
  // else {
  //   setCardIsAvailable( false );
  // }
}

void MicroSdCardReader::writeData( const Sensor *sensor )
{
  float measurement;
  float digitalMeasurement;
  
  if ( cardIsAvailable && 
       writingInCard && 
       dataFile && 
       ( numOfWrites > 0 || 
       numOfWrites == CONTINUOUS_DAQ ) )
  {

    digitalMeasurement = sensor->getDigitalMeasurement();
    measurement = sensor->getMeasurement();

    // Serial.print( digitalMeasurement );
    // Serial.print( DELIMETER );
    // Serial.print( measurement );
    // Serial.print( DELIMETER );

    dataFile.print( digitalMeasurement );
    dataFile.print( DELIMETER );
    dataFile.print( measurement );
    dataFile.print( DELIMETER );
  }

  // else {
  //   setCardIsAvailable( false );
  // }
}

void MicroSdCardReader::writeNewLine()
{

  if ( cardIsAvailable && 
       writingInCard && 
       dataFile && 
       ( numOfWrites > 0 || 
       numOfWrites == CONTINUOUS_DAQ ) )
  {
    // Serial.println();
    dataFile.println();

    if ( numOfWrites > 0 )
    {
      numOfWrites -= 1;
    }
  }
  // else
  // {
  //   setCardIsAvailable( false );
  // }
}


void MicroSdCardReader::openFile()
{
  if ( cardIsAvailable && writingInCard )
  {
    dataFile = SD.open( fileName, FILE_WRITE );
  }

  else
  {
    dataFile = File();
  }
}


void MicroSdCardReader::closeFile()
{
  dataFile.close();
}


File MicroSdCardReader::getFile()
{
  return dataFile;
}


const char *MicroSdCardReader::getFileName()
{
  return fileName;
}


void MicroSdCardReader::setCardIsAvailable( const bool isAvailable )
{
  cardIsAvailable = isAvailable;
}


void MicroSdCardReader::setWritingInCard( const bool isWriting )
{
  writingInCard = isWriting;
}


bool MicroSdCardReader::getWritingInCard()
{
  return writingInCard;
}


bool MicroSdCardReader::getCardIsAvailable()
{
  return cardIsAvailable;
}


void MicroSdCardReader::setNumOfWrites( int val )
{
  if ( val >= 0 )
  {
    origNumOfWrites = val;
    numOfWrites = val;
  }

  else 
  {
    origNumOfWrites = CONTINUOUS_DAQ;
    numOfWrites = CONTINUOUS_DAQ;
  }
}

int MicroSdCardReader::getNumOfWrites()
{
  return numOfWrites;
}


void MicroSdCardReader::resetNumOfWrites()
{
  numOfWrites = origNumOfWrites;
}