// Preprocess directives
#ifndef INFRARED_SENSOR_H
#define INFRARED_SENSOR_H

// Header files
#include "Sensor.h"
#include "Arduino.h"
#include "ArduinoUtilities.h"

  #define DEBOUNCE_TIME_MICROS 10000

  #define INFRARED_SENSOR_SAMPLE_AMT 25

  extern volatile unsigned long countsPerRev;
  extern volatile bool tooSlow;
  extern volatile unsigned long lastTime;

  void InfraredInterrupt();

  ISR( TIMER1_OVF_vect );

  class InfraredSensor : public Sensor {
    public:
      InfraredSensor( const int digitalPin, const char *rpmUnit, const unsigned int num_of_samples = 1, const unsigned int pulsePerRotation = 1 );

      void initialize() override;

      void startTimersAndInterrupts();

      void stopTimersAndInterrupts();

      void measure() override;

    private:
      int dPin;
      unsigned int ppr;
      unsigned int countsPerRevolution;
      float duration;
  };

#endif // INFRARED_SENSOR_H