// Header files
#include "InfraredSensor.h"

  volatile unsigned long countsPerRev = 0;
  volatile bool tooSlow = true;
  volatile unsigned long lastTime = 0;

void InfraredInterrupt() {

  unsigned long currentTime = micros();
  unsigned long durationTime = currentTime - lastTime; 
  // Serial.println( durationTime );
  if ( durationTime > DEBOUNCE_TIME_MICROS ) {
    lastTime = currentTime;
    countsPerRev = TCNT1;
    TCNT1 = 0;
    tooSlow = false;
  }
}

ISR( TIMER1_OVF_vect ) {
  tooSlow = true;
}

InfraredSensor::InfraredSensor( const int digitalPin, 
                                const char *speedUnit, 
                                const unsigned int num_of_samples = 1, 
                                const unsigned int pulsePerRotation = 1 )
{
  dPin = digitalPin;
  snprintf( unit, sizeof( unit ), "%s", speedUnit );
  sampleAmt = num_of_samples;
  ppr = pulsePerRotation;
  measurement = 0;
}

void InfraredSensor::initialize()
{
  TCCR1A = 0;
  TCCR1B = 0;
  pinMode( dPin, INPUT );
}

void InfraredSensor::startTimersAndInterrupts()
{
  TCCR1B |= (1 << CS12);              // Only set clock select bits
  TIMSK1 |= (1 << TOIE1);             // Enable overflow interrupt
  attachInterrupt( digitalPinToInterrupt( dPin ), InfraredInterrupt, FALLING );
}

void InfraredSensor::stopTimersAndInterrupts()
{
  TCCR1B &= ~( (1 << CS12 ) | ( 1 << CS11 ) | ( 1 << CS10 ) );
  TIMSK1 &= ~( 1 << TOIE1 );            // Disable overflow interrupt
  detachInterrupt( digitalPinToInterrupt( dPin ) );
}

void InfraredSensor::measure()
{
  unsigned long countsPerRevSum = 0;
  unsigned long prevCountsPerRev;
  unsigned long startWait;
  int validSamples = 0;

  measurement = 0;
  digitalMeasurement = 0;

  startTimersAndInterrupts();

  for ( int i = 0; i < sampleAmt; i++ ) {
    prevCountsPerRev = countsPerRev;
    startWait = millis();

    while ( countsPerRev == prevCountsPerRev && !tooSlow ) {
      if ( millis() - startWait > 250 ) { // safety timeout
        break;
      }
    }

    if ( !tooSlow && countsPerRev > 0 ) {
      countsPerRevSum += countsPerRev;
      validSamples++;
    } 
    
    else {
      break;
    }
  }

  stopTimersAndInterrupts();

  if ( validSamples == sampleAmt )
  {
    digitalMeasurement = ( float ) countsPerRevSum / sampleAmt;
    measurement = COUNTS_PER_MINUTE / ( digitalMeasurement * ppr );
  }
}

