// Header files
#include "ArduinoUtilities.h"

float getAnalogVoltage( const int digitalVal )
{
  return digitalVal * VOLTAGE_PER_DIGITAL_VALUE;
}

float getSeconds()
{
  return millis() / 1000.0;
}

float getVoltage( const int pinNumber, int *returnDigitalVal = NULL )
{
  const int digitalVal = getDigitalValue( pinNumber );

  if ( returnDigitalVal != NULL )
  {
    *returnDigitalVal = digitalVal;
  }

  return getAnalogVoltage( digitalVal );
}

int getDigitalValue( const int analogPin )
{
  return analogRead( analogPin );
}
