/*************************************************************************
 *
 *    File Name:   version.c
 *
 *    Description: Check versions
 *
 *    History:
 *       12 Apr 2000: Created; Joshua Colvin
 *       15 Apr 2000: Added VersionOpenDBIs; Joshua Colvin
 *
 *************************************************************************
 * Copyright (C) 2000 Jason Campbell, Joshua Colvin, Jason Sherrill,
 *                    Ben Tobin
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, In., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 *************************************************************************/

#include <PalmOS.h>
#include "version.h"

Boolean VersionCheckOS(UInt32 desiredVersion)
{
	UInt32 actualVersion;

	FtrGet(sysFtrCreator, sysFtrNumROMVersion, &actualVersion);

	if (actualVersion >= desiredVersion)
	{
		return true;
	}
	else // Older version
	{
		return false;
	}
}

Boolean VersionCheckOpenDB(DmOpenRef dbP, UInt16 desiredVersion)
{
	UInt16 actualVersion;
	LocalID dbID;
	UInt16 dbCardNo;
	
	// Get info on database
	DmOpenDatabaseInfo(dbP, &dbID, NULL, NULL,
	                   &dbCardNo, NULL); 
	// Get version number of DocListDB
	DmDatabaseInfo(dbCardNo, dbID, NULL, NULL,
	               &actualVersion, NULL, NULL, NULL, NULL,
	               NULL, NULL, NULL, NULL);
	
	return (actualVersion == desiredVersion);
}

void VersionSetOpenDB(DmOpenRef dbP, UInt16 newVersion)
{
	LocalID dbID;
	UInt16 dbCardNo;
	
	// Get info on database
	DmOpenDatabaseInfo(dbP, &dbID, NULL, NULL,
	                   &dbCardNo, NULL); 
	// Set version number of DocListDB
	DmSetDatabaseInfo(dbCardNo, dbID, NULL, NULL,
	               &newVersion, NULL, NULL, NULL, NULL,
	               NULL, NULL, NULL, NULL);
}

