/*************************************************************************
 *
 *    File Name:   menu.c
 *
 *    Description: hold all menu code
 *
 *    History:
 *       20 Apr 2000: Created; Jason Campbell
 *       27 Apr 2000: Cleaned up; Joshua Colvin
 *
 *************************************************************************
 * Copyright (C) 2000 Jason Campbell, Joshua Colvin, Jason Sherrill,
 *                    Ben Tobin
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, In., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 *************************************************************************/

#include <PalmOS.h>
#include "menu.h"
#include "docwhoRsc.h"
#include "doclist.h"
#include "docutil.h"

static Boolean MenuDocAll(EventPtr eventP);


Boolean MenuDocList(EventPtr eventP)
{
	Boolean handled;
	Err err;

	MenuEraseStatus(NULL);

	handled = MenuDocAll(eventP);
	if(false == handled)
	{	
		switch(eventP->data.menu.itemID)
		{
			case DocBeamCategory:
				err = DocListBeamCategory();
				if (err)
				{
					FrmCustomAlert(WarningAlert, "Beaming not completed",
					               NULL, NULL);
				}
				handled = true;
				break;
			case DocNew:
				err = DocUtilNew();
				if (err)
				{
					FrmCustomAlert(WarningAlert,
					               "Problems creating new Doc file",
					               NULL, NULL);
				}
				// Redraw Doc list
				FrmUpdateForm(DocListForm, frmUpdateEventReloadDBAndTable);
				handled = true;
				break;
		}
	}
	return handled;
}

Boolean MenuDocView(EventPtr eventP)
{
	UInt16 uintFocus;
	FieldPtr EditFld;
	FormPtr frmP;

	Boolean handled;
	MenuEraseStatus(NULL);

	handled = MenuDocAll(eventP);
	if(false == handled){	
		switch(eventP->data.menu.itemID)
		{
			case DocDone:
				FrmGotoForm(DocListForm);
				handled = true;
				break;
			case EditUndo:
				frmP = FrmGetActiveForm();
				uintFocus = FrmGetFocus(frmP);
				if(uintFocus == NULL){
					break;
				}															EditFld = FrmGetObjectPtr(frmP, uintFocus);
				FldUndo(EditFld);
				handled = true;
				break;
			case EditCut:
				frmP = FrmGetActiveForm();
				uintFocus = FrmGetFocus(frmP);
				if(uintFocus == NULL){
					break;
				}										
				EditFld = FrmGetObjectPtr(frmP, uintFocus);
				FldCut(EditFld);
				handled = true;
				break;
			case EditCopy:
				frmP = FrmGetActiveForm();
				uintFocus = FrmGetFocus(frmP);
				if(uintFocus == NULL){
					break;
				}										
				EditFld = FrmGetObjectPtr(frmP, uintFocus);
				FldCopy(EditFld);
				handled = true;
				break;
			case EditPaste:
				frmP = FrmGetActiveForm();
				uintFocus = FrmGetFocus(frmP);
				if(uintFocus == NULL){
					break;
				}										
				EditFld = FrmGetObjectPtr(frmP, uintFocus);
				FldPaste(EditFld);
				handled = true;
				break; 
			case EditSelectAll:
				frmP = FrmGetActiveForm();
				uintFocus = FrmGetFocus(frmP);
				if(uintFocus == NULL){
					break;
				}										
				EditFld = FrmGetObjectPtr(frmP, uintFocus);
				FldSetSelection(EditFld, 0, FldGetTextLength(EditFld));
				handled = true;
				break;
		}
	}
	return handled;
}

static Boolean MenuDocAll(EventPtr eventP)
{
	Boolean handled;

	handled = false;
	switch(eventP->data.menu.itemID)
	{
		case OptionsAbout:
			FrmAlert(AboutBoxAlert);
			handled = true;
			break;
	}
	return handled;
}
