/*************************************************************************
 *
 *    File Name:   doclistdb.h
 *
 *    Description: Functions for maintaining database for storing info
 *                  displayed by the Doc List
 *
 *    History:
 *       20 Mar 2000: Created; Joshua Colvin
 *       30 Mar 2000: Added comment headers; Jason Campbell

 *
 *************************************************************************
 * Copyright (C) 2000 Jason Campbell, Joshua Colvin, Jason Sherrill,
 *                    Ben Tobin
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, In., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 *************************************************************************/

// Used to store data in DocList database record
struct packedDocInfo
{
	UInt16 cardNo;
	LocalID dbID;
	UInt16 attributes;
	UInt32 crDate;
	UInt32 modDate;
	UInt32 bckUpDate;
	Char name[1]; // May be longer than 1
};
typedef struct packedDocInfo PackedDocInfoType;

// Used to compile data for DocList database record
struct docInfo
{
	UInt16 cardNo;
	LocalID dbID;
	UInt16 attributes;
	UInt32 crDate;
	UInt32 modDate;
	UInt32 bckUpDate;
	const Char *name;
};
typedef struct docInfo DocInfoType;


void DocListDBInit(void);

void DocListDBClose(void);

void DocListDBPopulate(void);

UInt16 DocListDBGetCategory(UInt16 recordIndex);

void DocListDBCategoryGetName (UInt16 category, Char *name);

void DocListDBGetInfo(UInt16 recordIndex,
                      UInt16 *cardNoP,
                      LocalID *dbIDP,
                      Char *name,
                      UInt16 *attributesP,
                      UInt32 *crDateP,
                      UInt32 *modDateP,
                      UInt32 *bckUpDateP);

void DocListDBGetNameHandle(UInt16 recordIndex, MemHandle *dataHandleP,
                            Int16 *dataOffsetP, Int16 *dataSizeP);

Boolean DocListDBUpdateDocName(UInt16 recordIndex);

void DocListDBUpdateCategory(UInt16 recordIndex, UInt16 newCategory);

MemHandle DocListDBQueryNextInCategory (UInt16* indexP,
                                        UInt16 category);

Err DocListDBSeekRecordInCategory (UInt16 *indexP, Int16 offset,
                                   Int16 direction, UInt16 category);

Boolean DocListDBCategorySelect(FormPtr frmP, UInt16 ctlID, UInt16 lstID,
                                Boolean title, UInt16 *categoryP,
                                Char *categoryName);
