/*************************************************************************
 *
 *    File Name:   control.c
 *
 *    Description: Utility functions for manipulation UI controls
 *
 *    History:
 *       20 Mar 2000: Created; Joshua Colvin
 *       30 Mar 2000: Added comment headers; Jason Campbell
 *       01 Apr 2000: Filled in comment headers; Joshua Colvin
 *
 *************************************************************************
 * Copyright (C) 2000 Jason Campbell, Joshua Colvin, Jason Sherrill,
 *                    Ben Tobin
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, In., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 *************************************************************************/
#include <PalmOS.h>

#include "control.h"

/*************************************************************************
 *
 *    Function Name: ControlGetPtrByID
 *
 *    Purpose:       returns pointer to UI object given form and object ID
 *
 *    Parameters:    frmP:  pointer to form
 *                   objID: ID of object to get pointer of
 *
 *    Return Value:  pointer to object identified by objID
 *
 *
 *************************************************************************/
void *ControlGetPtrByID(FormPtr frmp, UInt16 objID)
{
	UInt16 objIndex;
	void *objPtr;
	objIndex = FrmGetObjectIndex(frmp, objID);
	objPtr = FrmGetObjectPtr(frmp, objIndex);
	return objPtr;
}

